<?php
// pay/notify.php
require __DIR__.'/db.php';

// ===== ENV =====
function envget($k,$d=null){ $v=getenv($k); return $v===false?$d:$v; }
$SECRET_KEY = envget('QEA_SECRET', '172aab7861464f4182eb95608c8ecc38');

// ===== logger =====
function log_notify($msg){
    $file = __DIR__.'/notify.log';
    file_put_contents($file, date('c')." ".$msg."\n", FILE_APPEND);
}

// ===== signature helper =====
function make_md5_sign_response(array $resp, string $secretKey, ?string &$baseOut = null): string {
    $order = ['mchId','mchOrderNo','orderDate','orderNo','oriAmount','payInfo','respCode','tradeAmount','tradeMsg','tradeResult'];
    $pairs = [];
    foreach ($order as $k) {
        if (!array_key_exists($k, $resp)) continue;
        $v = $resp[$k];
        if ($v === null) continue;
        $vStr = is_bool($v) ? ($v ? 'true' : 'false') : (string)$v;
        if ($vStr === '') continue;
        $pairs[] = "{$k}={$vStr}";
    }
    $base = implode('&', $pairs) . "&key={$secretKey}";
    if ($baseOut !== null) $baseOut = $base;
    return md5($base);
}

// ===== read payload =====
$payload = $_POST;
if (empty($payload)) {
    $raw = file_get_contents('php://input');
    $try = json_decode($raw, true);
    if (is_array($try)) $payload = $try;
}

log_notify("RAW ".json_encode($payload, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES));

// ===== validate presence =====
if (!isset($payload['respCode'], $payload['tradeResult'], $payload['sign'])) {
    log_notify("MISSING_FIELDS");
    http_response_code(400);
    echo "MISSING_FIELDS";
    exit;
}

// ===== signature verify =====
$base = null;
$calc = make_md5_sign_response($payload, $SECRET_KEY, $base);
$given = strtolower($payload['sign']);
$ok    = hash_equals($given, strtolower($calc));

log_notify("VERIFY mchOrderNo=".($payload['mchOrderNo'] ?? '')." calc={$calc} given={$given} ok=".($ok?'1':'0'));

if (!$ok) {
    http_response_code(400);
    echo "SIGNATURE_ERROR";
    exit;
}

// ===== business fields =====
$mchOrderNo  = $payload['mchOrderNo'] ?? '';
$orderNo     = $payload['orderNo'] ?? '';
$respCode    = $payload['respCode'] ?? '';
$tradeResult = $payload['tradeResult'] ?? '';
$amount      = $payload['tradeAmount'] ?? '';
$rawJson     = json_encode($payload, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);

// ===== DB update with idempotency =====
try {
    $pdo = pdo_sqlsrv();
    $pdo->beginTransaction();

    $q = $pdo->prepare("SELECT TOP 1 * FROM dbo.Orders WITH (UPDLOCK, ROWLOCK) WHERE MchOrderNo = :m");
    $q->execute([':m'=>$mchOrderNo]);
    $order = $q->fetch();

    $newStatus = 'failed';

    if (!$order) {
        log_notify("UNKNOWN_ORDER {$mchOrderNo}");
        $ins = $pdo->prepare("INSERT INTO dbo.Orders (MchOrderNo, GoodsName, Amount, Status, RawNotify, UpdatedAt)
                              VALUES (:m,'UNKNOWN',0,'pending',:raw,SYSUTCDATETIME())");
        $ins->execute([':m'=>$mchOrderNo, ':raw'=>$rawJson]);
    } else {
        if (strcasecmp($order['Status'], 'paid') === 0) {
            log_notify("ALREADY_PAID {$mchOrderNo}");
            $pdo->commit();
            echo "OK";
            exit;
        }

        if ($respCode === 'SUCCESS' && $tradeResult === '1') {
            $newStatus = 'paid';
            $upd = $pdo->prepare("UPDATE dbo.Orders
                SET Status='paid', GatewayOrderNo=:go, RespCode=:rc, TradeResult=:tr,
                    RawNotify=:raw, PaidAt=SYSUTCDATETIME(), UpdatedAt=SYSUTCDATETIME()
                WHERE Id=:id");
            $upd->execute([
                ':go'=>$orderNo, ':rc'=>$respCode, ':tr'=>$tradeResult,
                ':raw'=>$rawJson, ':id'=>$order['Id']
            ]);
        } else {
            $newStatus = 'failed';
            $upd = $pdo->prepare("UPDATE dbo.Orders
                SET Status='failed', GatewayOrderNo=:go, RespCode=:rc, TradeResult=:tr,
                    RawNotify=:raw, UpdatedAt=SYSUTCDATETIME()
                WHERE Id=:id");
            $upd->execute([
                ':go'=>$orderNo, ':rc'=>$respCode, ':tr'=>$tradeResult,
                ':raw'=>$rawJson, ':id'=>$order['Id']
            ]);
        }
    }

    $pdo->commit();
    log_notify("UPDATE {$mchOrderNo} status={$newStatus}");
    echo "OK";
} catch (Throwable $e) {
    if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
    log_notify("DB_ERROR {$mchOrderNo} ".$e->getMessage());
    http_response_code(500);
    echo "SERVER_ERROR";
}